# This script promotes a Windows Server to Domain Controller status

# Place the prebuild-dc-2.ps1 script in C:\users\administrator\desktop

Write-Host "Promoting our windows server to domain controller"

Set-DnsClientServerAddress -InterfaceIndex (Get-NetAdapter).InterfaceIndex -ServerAddresses ("127.0.0.1","8.8.8.8")
Install-WindowsFeature -Name AD-Domain-Services -IncludeManagementTools
$SecPassword = ConvertTo-SecureString 'ADMINPASSWORD' -AsPlainText -Force
rm C:\users\administrator\desktop\prebuild-dc-2.ps1
Install-ADDSForest -DomainName "yourdomain.com" -CreateDnsDelegation:$false -DatabasePath "C:\Windows\NTDS" -SafeModeAdministratorPassword $SecPassword -DomainMode "7" -DomainNetbiosName "YOURDOMAIN" -ForestMode "7" -InstallDns:$true -LogPath "C:\Windows\NTDS" -SysvolPath "C:\Windows\SYSVOL" -Force:$true
